<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erreur - Dépôt</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(180deg, #0b4d34 0%, #063b28 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: #333;
        }
        
        .header {
            background: #0b4d34;
            color: white;
            padding: 16px;
            text-align: center;
            font-size: 18px;
            font-weight: 600;
            position: relative;
        }
        
        .back-btn {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: white;
            font-size: 28px;
            text-decoration: none;
        }
        
        .container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .error-card {
            background: white;
            border-radius: 24px;
            padding: 30px 20px;
            max-width: 400px;
            width: 100%;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .error-icon {
            width: 80px;
            height: 80px;
            background: #ffebee;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
        }
        
        .error-title {
            font-size: 22px;
            font-weight: 700;
            color: #d32f2f;
            margin-bottom: 15px;
        }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 12px;
            margin: 20px 0;
            font-size: 15px;
            text-align: left;
            word-break: break-word;
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 15px;
            background: #0f6a3f;
            color: white;
            text-decoration: none;
            border-radius: 30px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            margin: 15px 0;
        }
        
        .btn:hover {
            background: #19a34a;
        }
        
        .help-text {
            color: #666;
            font-size: 14px;
            line-height: 1.5;
        }
    </style>
</head>
<body>
    <div class="header">
        <a href="javascript:history.back()" class="back-btn">‹</a>
        Erreur
    </div>
    
    <div class="container">
        <div class="error-card">
            <div class="error-icon">⚠️</div>
            <div class="error-title">Erreur de dépôt</div>
            <div class="error-message"><?php echo e($message ?? 'Une erreur est survenue'); ?></div>
            <p class="help-text">Vérifiez votre connexion et réessayez.</p>
            <a href="<?php echo e(route('deposit.select')); ?>" class="btn">Retour au dépôt</a>
        </div>
    </div>
</body>
</html><?php /**PATH /home2/rrelliaa/taskfi.us.cc/resources/views/app/main/deposit/error.blade.php ENDPATH**/ ?>