<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Recharger - Stanford AI</title>

<style>
:root {
    /* Palette Stanford AI extraite de tes images */
    --bg-page: #060212;
    --card-bg: #12062b;
    --text-white: #ffffff;
    --accent-blue: #00d2ff;
    --grad-stanford: linear-gradient(135deg, #ff00cc 0%, #3333ff 100%);
    --border-glow: rgba(255, 0, 204, 0.2);
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    background-color: var(--bg-page);
    color: var(--text-white);
    min-height: 100vh;
}

/* TOP BAR */
.topbar {
    background: #0f0524;
    color: #fff;
    text-align: center;
    padding: 18px;
    font-size: 19px;
    font-weight: 700;
    position: relative;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.back {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    width: 25px;
    height: 25px;
    border-left: 2px solid #fff;
    border-bottom: 2px solid #fff;
    transform: translateY(-50%) rotate(45deg);
    text-decoration: none;
}

/* LAYOUT */
.container {
    max-width: 480px;
    margin: auto;
    padding: 20px 15px;
}

/* CARD - Style Stanford */
.card {
    background: var(--card-bg);
    border-radius: 24px;
    padding: 25px 20px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
    position: relative;
}

/* CLUB HEADER */
.club-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 25px;
    justify-content: center;
}
.club-logo { width: 30px; filter: drop-shadow(0 0 5px var(--accent-blue)); }
.club-name { font-size: 16px; font-weight: 700; color: var(--accent-blue); letter-spacing: 1px; }

/* CRYPTO LOGO */
.crypto-section {
    text-align: center;
    margin-bottom: 20px;
}
.crypto-circle {
    width: 65px;
    height: 65px;
    background: var(--grad-stanford);
    border-radius: 50%;
    margin: 0 auto 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 0 20px var(--border-glow);
}
.crypto-logo { width: 35px; height: 35px; object-fit: contain; }
.crypto-symbol { font-size: 22px; font-weight: 800; color: #fff; display: block; }

/* QR CODE */
.qr-wrapper { text-align: center; margin-bottom: 20px; }
.qr-container {
    display: inline-block;
    padding: 15px;
    background: #fff; /* Garder le fond blanc pour la lisibilité du QR */
    border-radius: 18px;
    box-shadow: 0 0 25px rgba(255, 255, 255, 0.1);
}
.qr-container img { width: 180px; height: 180px; display: block; }

/* ADDRESS BOX */
.label {
    text-align: center;
    font-weight: 600;
    font-size: 15px;
    margin-bottom: 10px;
    color: rgba(255, 255, 255, 0.6);
}
.address-box {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 15px;
    padding: 8px 8px 8px 15px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(255, 255, 255, 0.1);
}
.address-text {
    flex: 1;
    font-family: 'Courier New', monospace;
    font-size: 13px;
    color: #fff;
    overflow: hidden;
    text-overflow: ellipsis;
}
.copy-btn {
    background: var(--grad-stanford);
    color: #fff;
    border: none;
    padding: 10px 18px;
    border-radius: 12px;
    font-weight: 700;
    cursor: pointer;
    box-shadow: 0 4px 10px rgba(255, 0, 204, 0.3);
}

/* MAIN ACTION BUTTON */
.action-btn {
    width: 100%;
    background: var(--grad-stanford);
    color: #fff;
    border: none;
    padding: 18px;
    border-radius: 18px;
    font-size: 18px;
    font-weight: 800;
    margin-top: 25px;
    text-transform: uppercase;
    letter-spacing: 1px;
    box-shadow: 0 8px 20px rgba(51, 51, 255, 0.3);
}

/* INSTRUCTIONS */
.instructions {
    margin-top: 30px;
    padding: 15px;
    background: rgba(255, 255, 255, 0.03);
    border-radius: 15px;
    font-size: 13px;
    color: #b0a8c3;
    line-height: 1.6;
}
.instructions h4 { color: #fff; margin-bottom: 10px; display: flex; align-items: center; gap: 5px; }
.instructions p { margin-bottom: 8px; }
.check { color: var(--accent-blue); font-weight: bold; }
</style>
</head>

<body>

<div class="topbar">
    <a href="javascript:history.back()" class="back"></a>
    Recharger
</div>

<div class="container">
    <div class="card">

        <div class="club-header">
            <img src="/crypto/logo.png" class="club-logo">
            <span class="club-name">STANFORD AI SYSTEM</span>
        </div>

        <?php
        $currency = strtolower($oxapayData['pay_currency'] ?? 'bnb');
        ?>

        <div class="crypto-section">
            <div class="crypto-circle">
                <img src="/crypto/<?php echo e($currency); ?>.png" class="crypto-logo">
            </div>
            <span class="crypto-symbol"><?php echo e(strtoupper($currency)); ?></span>
        </div>

        <div class="qr-wrapper">
            <div class="qr-container">
                <img src="<?php echo e($oxapayData['qr_code'] ?? ''); ?>">
            </div>
        </div>

        <div class="label">Adresse de dépôt</div>

        <div class="address-box">
            <div class="address-text" id="walletAddr">
                <?php echo e($oxapayData['address'] ?? '...'); ?>

            </div>
            <button class="copy-btn" onclick="copyAddress()">COPIE</button>
        </div>

        <button class="action-btn" onclick="location.reload()">Recharge terminée</button>

        <div class="instructions">
            <h4><span class="check">●</span> Instructions de recharge</h4>
            <p>1. Scannez le QR code ou copiez l'adresse pour effectuer le dépôt.</p>
            <p>2. Assurez-vous d'utiliser le réseau correct pour éviter la perte des fonds.</p>
            <p>3. Le dépôt sera crédité automatiquement après confirmation sur la blockchain.</p>
        </div>

    </div>
</div>

<script>
function copyAddress(){
    const text = document.getElementById("walletAddr").innerText.trim();
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(text).then(function(){
            alert("Adresse copiée avec succès !");
        });
    } else {
        const textarea = document.createElement("textarea");
        textarea.value = text;
        textarea.style.position = "fixed";
        textarea.style.left = "-9999px";
        document.body.appendChild(textarea);
        textarea.select();
        document.execCommand("copy");
        document.body.removeChild(textarea);
        alert("Adresse copiée avec succès !");
    }
}
</script>

</body>
</html><?php /**PATH /home2/rrelliaa/demo2.taskfi.us.cc/resources/views/app/main/deposit/crypto-deposit.blade.php ENDPATH**/ ?>