<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Slectionner la devise</title>

<style>
:root {
    /* Couleurs exactes extraites de ton screenshot */
    --bg-page: #060212; /* Le noir trs profond du fond */
    --bg-card: #12062b; /* Le violet sombre de la zone centrale */
    --border-color: #241644; /* La couleur des lignes de sparation */
    --text-white: #ffffff;
    --text-muted: #b0a8c3;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    -webkit-tap-highlight-color: transparent;
}

body {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
    background-color: var(--bg-page);
    color: var(--text-white);
    min-height: 100vh;
}

/* TOP BAR */
.topbar {
    background-color: #12062b;
    height: 60px;
    display: flex;
    align-items: center;
    padding: 0 15px;
    position: sticky;
    top: 0;
    z-index: 100;
}

.back-btn {
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    text-decoration: none;
}

.back-btn::before {
    content: "";
    width: 10px;
    height: 10px;
    border-left: 2px solid white;
    border-bottom: 2px solid white;
    transform: rotate(45deg);
}

.topbar-title {
    flex: 1;
    text-align: center;
    font-size: 18px;
    font-weight: 600;
    margin-right: 30px; /* Compense la flche pour centrer */
}

/* CONTAINER */
.wrapper {
    padding: 20px 15px;
}

/* LA CARTE CENTRALE */
.card {
    background-color: var(--bg-card);
    border-radius: 16px;
    overflow: hidden;
}

/* CHAQUE LIGNE DE CRYPTO */
.item {
    display: flex;
    align-items: center;
    padding: 18px 16px;
    border-bottom: 1px solid var(--border-color);
    cursor: pointer;
    transition: background 0.2s;
}

.item:active {
    background-color: rgba(255, 255, 255, 0.05);
}

.item:last-child {
    border-bottom: none;
}

/* ICNE AVEC FOND SOMBRE */
.icon-box {
    width: 44px;
    height: 44px;
    background-color: #20133d; /* Fond de l'icne dans ton screen */
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
}

.icon-box img {
    width: 26px;
    height: 26px;
    object-fit: contain;
}

/* TEXTE DU NOM */
.name {
    flex: 1;
    font-size: 16px;
    font-weight: 600;
    color: #ffffff;
    letter-spacing: 0.3px;
}

/* FLCHE  DROITE */
.arrow-right {
    width: 20px;
    height: 20px;
    opacity: 0.5;
}

.arrow-right::after {
    content: "";
    display: block;
    width: 8px;
    height: 8px;
    border-top: 2px solid white;
    border-right: 2px solid white;
    transform: rotate(45deg);
    margin-left: 4px;
}

/* FALLBACK ICON */
.fallback-text {
    font-size: 10px;
    font-weight: bold;
    color: #8e84ad;
}
</style>
</head>

<body>

<div class="topbar">
    <a href="/home" class="back-btn"></a>
    <div class="topbar-title">Recharger</div>
</div>

<div class="wrapper">
    <div class="card">

    @foreach($cryptos as $crypto)
    @php
        $rawSymbol = trim($crypto['symbol'] ?? '');
        $rawNetwork = trim($crypto['network'] ?? '');
        $symbolLow = strtolower($rawSymbol);
        
        // Logique pour l'icne
        $iconName = ($symbolLow === 'usdt' && (str_contains(strtolower($rawNetwork),'bep'))) ? 'usdt20' : $symbolLow;
        $iconUrl = route('crypto.icon',['icon'=>$iconName.'.png']);
    @endphp

    <div class="item" onclick="processDeposit('{{ $rawSymbol }}','{{ $rawNetwork }}')">
        
        <div class="icon-box" id="box-{{ $loop->index }}">
            <span class="fallback-text">{{ substr(strtoupper($rawSymbol),0,3) }}</span>
        </div>

        <div class="name">
            {{ $rawNetwork ? strtoupper($rawNetwork).'-' : '' }}{{ strtoupper($rawSymbol) }}
        </div>

        <div class="arrow-right"></div>
    </div>

    <script>
    (function(){
        const box = document.getElementById('box-{{ $loop->index }}');
        const img = new Image();
        img.onload = function(){
            box.innerHTML = `<img src="${this.src}" alt="">`;
        };
        img.src = '{{ $iconUrl }}';
    })();
    </script>

    @endforeach

    </div>
</div>

<script>
function processDeposit(currency, network){
    let url = '/deposit-oxapay/' + encodeURIComponent(currency);
    if(network && network.trim() !== ''){
        url += '/' + encodeURIComponent(network);
    }
    window.location.href = url;
}
</script>

</body>
</html>